--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNskyDome ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCmapSize  = [166,40]
  local LOCpreviewBitmap
  local LOCrenderMap

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNresetSky FUNmrSkySwitch =
  (
    local LOCsceneMats = sceneMaterials
    if LOCsceneMats[DYNmatNameEnvironment] != undefined then
    (
      if (DYNFUNisMentalRayProductionRenderer()) then
      (
        if FUNmrSkySwitch then
        (
          LOCsceneMats[DYNmatNameEnvironment] = mr_Physical_Sky name:DYNmatNameEnvironment
        )
        else
        (
          LOCsceneMats[DYNmatNameEnvironment] = gradient name:DYNmatNameEnvironment
        )
      )
      else
      (
        LOCsceneMats[DYNmatNameEnvironment] = gradient name:DYNmatNameEnvironment
      )
      environmentMap = LOCsceneMats[DYNmatNameEnvironment]
    )
    else
    (
      if (DYNFUNisMentalRayProductionRenderer()) then
      (
        if FUNmrSkySwitch then
        (
          environmentMap = mr_Physical_Sky name:DYNmatNameEnvironment
        )
        else
        (
          environmentMap = gradient name:DYNmatNameEnvironment
        )
      )
      else
      (
        environmentMap = gradient name:DYNmatNameEnvironment
      )
    )
    UseEnvironmentMap = true

    DYNFUNresetEnvironmentMap()
    DYNskyDome.DYNFUNdisplaySkyParams()
    DYNmrPhysicalSky.DYNFUNdisplaySkyParams()
    DYNskyDome.DYNFUNupdateSkyPreview()

    if classOf environmentMap == mr_Physical_Sky then
    (
      try (removeRollout DYNskyDome DYNmainFloater) catch ()
      addrollout DYNmrPhysicalSky DYNmainFloater rolledup:false
    )
    else
    (
      try (removeRollout DYNmrPhysicalSky DYNmainFloater) catch ()
      addrollout DYNskyDome DYNmainFloater rolledup:false
    )

  )

  fn DYNFUNupdateSkyPreview =
  (
    if DYNskyDome.open then
    (
      if DYNskyDome.CBDYNonOff.checked then
      (
        DYNskyDome.LOCrenderMap = renderMap environmentMap size:[(DYNiniExplorerWidth - 27),240]
        DYNskyDome.LOCrenderMap.height = 120
      )
      else
      (
        DYNskyDome.LOCrenderMap = bitmap (DYNiniExplorerWidth - 27) 120 color:black
      )
      DYNskyDome.BMDYNrenderMap.bitmap = DYNskyDome.LOCrenderMap
    )
  )

  fn DYNFUNdisplaySkyControls =
  (
    for i in DYNskyDome.controls do i.enabled = false
    DYNskyDome.BUDYNreset.enabled = true
    DYNskyDome.DYNFUNupdateSkyPreview()
  )

  fn DYNFUNdisplaySkyParams =
  (
    if DYNskyDome.open then
    (
      local LOCsceneMats = sceneMaterials
      if LOCsceneMats[DYNmatNameEnvironment] == environmentMap and (classof LOCsceneMats[DYNmatNameEnvironment]) == Gradient then
      (
        --- Make the Array of Library Image Files
        local LOCskymaps = DYNFUNlistLibraryMaps DYNSkyMapPath

        DYNskyDome.CBDYNonOff.checked      = useEnvironmentMap
        DYNskyDome.CODYNtint.color         = environmentMap.color2
        DYNskyDome.SPDYNcolor2pos.value    = environmentMap.color2pos
        DYNskyDome.SPDYNnoiseSize.value    = environmentMap.noiseSize
        DYNskyDome.SPDYNnoisePhase.value   = environmentMap.noisePhase
        DYNskyDome.SPDYNnoiseLevels.value  = environmentMap.noiseLevels
        DYNskyDome.SPDYNrgbLevel.value     = environmentMap.output.rgb_level
        DYNskyDome.SPDYNvOffset.value      = environmentMap.coords.V_Offset
        DYNskyDome.SPDYNuOffset.value      = environmentMap.coords.U_Offset
        for i in DYNskyDome.controls do i.enabled = true

        if environmentMap.map1 != undefined and LOCskymaps.count > 0 then
        (
          DYNskyDome.DDDYNskyMap.enabled   = true
          DYNskyDome.BMDYNskyMap.enabled   = true
          DYNskyDome.DDDYNskyMap.items     = LOCskymaps
          DYNskyDome.DDDYNskyMap.selection = findItem LOCskyMaps (filenameFromPath environmentmap.map1.filename)
          DYNskyDome.BMDYNskyMap.bitmap    = DYNFUNrenderBitMap (DYNiniExplorerWidth - 27) DYNskyDome.LOCmapSize.y environmentmap.map1.filename
        )
        else
        (
          DYNskyDome.DDDYNskyMap.enabled   = false
          DYNskyDome.BMDYNskyMap.enabled   = false
          DYNskyDome.DDDYNskyMap.items     = #()
          DYNskyDome.BMDYNskyMap.bitmap    = bitmap (DYNiniExplorerWidth - 27) DYNskyDome.LOCmapSize.y color:(color 255 255 255)
        )
        DYNskyDome.DYNFUNupdateSkyPreview()
      )
      else
      (
        DYNFUNdisplaySkyControls()
      )
    )

  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  checkbox CBDYNonoff align:#left pos:[4,9]
  button BUDYNshow width:(DYNiniExplorerWidth - 78) pos:[59,6]

  label LBDYNrenderMap align:#left pos:[4,38]
  bitmap  BMDYNrenderMap width:(DYNiniExplorerWidth - 21) height:120 pos:[4,55]

  label LBDYNbasic align:#left pos:[4,185]
  bitmap  BMDYNskyMap width:(DYNiniExplorerWidth - 21) height:LOCmapSize.y pos:[4,202]
  dropdownlist DDDYNskyMap width:(DYNiniExplorerWidth - 51) align:#left pos:[5,249]
  button BUDYNpreview width:21 height:21 pos:[(DYNiniExplorerWidth - 40),249] iconName:"Common/Zoom"

  groupbox GBDYNgroup01 width:(DYNiniExplorerWidth - 21) height:141 pos:[4,277]
  colorpicker CODYNtint fieldwidth:(DYNiniExplorerWidth - 45) height:20 pos:[13,299]
  spinner SPDYNcolor2pos   pos:[(DYNiniExplorerWidth - 96),329] fieldwidth:60 range:[0,1,0]    scale:0.01 align:#left
  spinner SPDYNnoiseLevels pos:[(DYNiniExplorerWidth - 96),350] fieldwidth:60 range:[0,10,0]   scale:0.1  align:#left
  spinner SPDYNnoiseSize   pos:[(DYNiniExplorerWidth - 96),371] fieldwidth:60 range:[0,1000,0] scale:0.1  align:#left
  spinner SPDYNnoisePhase  pos:[(DYNiniExplorerWidth - 96),392] fieldwidth:60 range:[0,1000,0] scale:0.1  align:#left
  label LBDYNcolor2pos   pos:[13,332] width:95 align:#left
  label LBDYNnoiseLevels pos:[13,353] width:95 align:#left
  label LBDYNnoiseSize   pos:[13,374] width:95 align:#left
  label LBDYNnoisePhase  pos:[13,395] width:95 align:#left

  groupbox GBDYNgroup02 width:(DYNiniExplorerWidth - 21) height:90 pos:[4,427]
  spinner SPDYNrgbLevel   pos:[(DYNiniExplorerWidth - 96),448] fieldwidth:60 range:[0.1,1.5,1] scale:0.01 align:#left
  spinner SPDYNvOffset    pos:[(DYNiniExplorerWidth - 96),469] fieldwidth:60 range:[-1,1,0]    scale:0.01 align:#left
  spinner SPDYNuOffset    pos:[(DYNiniExplorerWidth - 96),490] fieldwidth:60 range:[-1,1,0]    scale:0.01 align:#left
  label LBDYNrgbLevel     pos:[13,451] width:95 align:#left
  label LBDYNvOffset      pos:[13,472] width:95 align:#left
  label LBDYNuOffset      pos:[13,493] width:95 align:#left

  button BUDYNreset width:(DYNiniExplorerWidth - 21) algin:#center pos:[4,526]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on dynSkyDome open do
  (
    DYNskyDome.title      = DYNuiRolloutNames[22]
    GBDYNgroup01.text     = DYNuiResourcesGroups[65]
    GBDYNgroup02.text     = DYNuiResourcesGroups[3]
    LBDYNrenderMap.text   = DYNuiResourcesLabels[207]
    LBDYNbasic.text       = DYNuiResourcesLabels[208]
    BUDYNshow.text        = DYNuiResourcesButtons[34]
    BUDYNreset.text       = DYNuiResourcesButtons[13]
    LBDYNcolor2pos.text   = DYNuiResourcesLabels[35]
    LBDYNnoiseSize.text   = DYNuiResourcesLabels[36]
    LBDYNnoisePhase.text  = DYNuiResourcesLabels[37]
    LBDYNnoiseLevels.text = DYNuiResourcesLabels[38]
    LBDYNrgbLevel.text    = DYNuiResourcesLabels[39]
    LBDYNvOffset.text     = DYNuiResourcesLabels[2]
    LBDYNuOffset.text     = DYNuiResourcesLabels[1]
    CBDYNonOff.text       = DYNuiResourcesLabels[22]
    DYNFUNdisplaySkyParams()
  )

  on DYNskyDome close do
  (
    if (classOf LOCpreviewBitmap) == bitMap then
    (
      close LOCpreviewBitmap
      LOCpreviewBitmap = undefined
    )

    if (classOf LOCrenderMap) == bitMap then
    (
      close LOCrenderMap
      LOCrenderMap = undefined
    )
  )

  on CODYNtint        changed val do (try (environmentMap.color2 = val; DYNFUNupdateSkyPreview()) catch (DYNFUNdisplaySkyControls()))
  on SPDYNcolor2pos   changed val do (try (environmentMap.color2pos = val; DYNFUNupdateSkyPreview()) catch (DYNFUNdisplaySkyControls()))
  on SPDYNnoiseSize   changed val do (try (environmentMap.noiseSize = val; DYNFUNupdateSkyPreview()) catch (DYNFUNdisplaySkyControls()))
  on SPDYNnoisePhase  changed val do (try (environmentMap.noisePhase = val; DYNFUNupdateSkyPreview()) catch (DYNFUNdisplaySkyControls()))
  on SPDYNnoiseLevels changed val do (try (environmentMap.noiseLevels = val; DYNFUNupdateSkyPreview()) catch (DYNFUNdisplaySkyControls()))
  on SPDYNrgbLevel    changed val do (try (environmentMap.output.rgb_level = val; DYNFUNupdateSkyPreview()) catch (DYNFUNdisplaySkyControls()))
  on SPDYNvOffset     changed val do
  (
    try
    (
      environmentMap.map1.coords.V_Offset += (val - environmentMap.coords.V_Offset)
      environmentMap.coords.V_Offset = val
      DYNFUNupdateSkyPreview()
    )
    catch (DYNFUNdisplaySkyControls())
  )
  on SPDYNuOffset     changed val do
  (
    try
    (
      environmentMap.coords.U_Offset = val
      environmentMap.map1.coords.U_Offset = val
      DYNFUNupdateSkyPreview()
    )
    catch (DYNFUNdisplaySkyControls())
  )

  on CBDYNonOff       changed val do
  (
    try
    (
      useEnvironmentMap = val
      if val == false then DYNamite.SkyNode.forecolor = DYNFUNdnColor (DYNINIgreyedOutColor) else DYNamite.SkyNode.forecolor = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
      DYNFUNupdateSkyPreview()
    )
    catch (DYNFUNdisplaySkyControls())
  )

  on BUDYNreset pressed do
  (
    DYNFUNresetSky true
  )

  on DDDYNskyMap selected arg do
  (
    try
    (
      environmentmap.map1.filename = DYNSkyMapPath + DDDYNskyMap.selected
      environmentmap.map1.name     = getFilenameFile DDDYNskyMap.selected
      BMDYNskyMap.bitmap           = DYNFUNrenderBitMap (DYNiniExplorerWidth - 27) LOCmapSize.y environmentmap.map1.filename
      DYNFUNupdateSkyPreview()
    )
    catch (DYNFUNdisplaySkyControls())
  )

  on BUDYNpreview pressed do
  (
    try
    (
      LOCpreviewBitmap = openBitMap (DYNSkyMapPath + DDDYNskyMap.selected)
      if (classOf LOCpreviewBitmap) == bitMap then
      (
        display LOCpreviewBitmap
      )
      else (messageBox (DYNuiResourcesErrorsWarnings[30]) title:DYNuiResourcesTitlebars[1])
    )
    catch (DYNFUNdisplaySkyControls())
  )

  on BUDYNshow pressed do (max background display toggle)
)
